/**
*    PouringRain.cpp
*    
*    Extention of Routine to display the cube filling up with rain.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "PouringRain.h"

PouringRain::PouringRain()
{
	timeSinceLastStep = 0;
	spawnDrop = true;
}

void PouringRain::update(unsigned long dt)
{
	timeSinceLastStep += dt;
	
	if (timeSinceLastStep > STEP_TIME)
	{
		if (spawnDrop)
		{
			byte lit = 0;
			
			for ( byte x = 0; x < CUBE_SIZE; x++)
			{
				for ( byte y = 0; y < CUBE_SIZE; y++)
				{	
					if (cubeModel[x][y][CUBE_SIZE - 1])
					{
						lit++;
						
					}
				}
			}
			if(lit == CUBE_SIZE*CUBE_SIZE)
			{
				for(byte x = 0 ; x < CUBE_SIZE ; x++)
				{
					for(byte y = 0 ; y < CUBE_SIZE ; y++)
					{
						for(byte z = 0 ; z < CUBE_SIZE ; z++)
						{
							cubeModel[x][y][z] = false;
						}
					}
				}
				return;
			}
			byte randomIndex = random(CUBE_SIZE*CUBE_SIZE - lit);
			
			byte unlit = 0;
			
			for ( byte x = 0; x < CUBE_SIZE; x++)
			{
				for ( byte y = 0; y < CUBE_SIZE; y++)
				{
					if(!cubeModel[x][y][CUBE_SIZE - 1])
					{
						if(randomIndex == unlit)
						{
							cubeModel[x][y][CUBE_SIZE - 1] = true;
							xCurrent = x;
							yCurrent = y;
							zCurrent = CUBE_SIZE - 1;
							spawnDrop = false;
						}
						unlit ++;
					}
				}
			}
		}
		else
		{
			if(cubeModel[xCurrent][yCurrent][zCurrent - 1] || zCurrent == 0)
			{
				spawnDrop = true;
			}
			else
			{
				cubeModel[xCurrent][yCurrent][zCurrent] = false;
				zCurrent--;
				cubeModel[xCurrent][yCurrent][zCurrent] = true;
			}
		}	
		timeSinceLastStep -= STEP_TIME;
	}
}	